import { memo } from '@wordpress/element';
import { __ } from '@wordpress/i18n';

const Logo = (props) => {
	const { className, ...otherProps } = props;

	return (
		<svg
			className={className}
			viewBox="0 0 2524 492"
			xmlns="http://www.w3.org/2000/svg"
			{...otherProps}
		>
			<title>{__('Logo Icon', 'extendify-local')}</title>
			<path
				d="M609.404 378.5C585.07 378.5 563.404 373 544.404 362C525.737 350.667 511.07 335.333 500.404 316C489.737 296.333 484.404 273.833 484.404 248.5C484.404 222.833 489.57 200.167 499.904 180.5C510.237 160.833 524.737 145.5 543.404 134.5C562.07 123.167 583.404 117.5 607.404 117.5C632.404 117.5 653.904 122.833 671.904 133.5C689.904 143.833 703.737 158.333 713.404 177C723.404 195.667 728.404 218 728.404 244V262.5L516.404 263L517.404 224H667.904C667.904 207 662.404 193.333 651.404 183C640.737 172.667 626.237 167.5 607.904 167.5C593.57 167.5 581.404 170.5 571.404 176.5C561.737 182.5 554.404 191.5 549.404 203.5C544.404 215.5 541.904 230.167 541.904 247.5C541.904 274.167 547.57 294.333 558.904 308C570.57 321.667 587.737 328.5 610.404 328.5C627.07 328.5 640.737 325.333 651.404 319C662.404 312.667 669.57 303.667 672.904 292H729.404C724.07 319 710.737 340.167 689.404 355.5C668.404 370.833 641.737 378.5 609.404 378.5Z"
				fill="currentColor"
			/>
			<path
				d="M797.529 372H728.029L813.029 251L728.029 125H799.029L853.529 209L906.029 125H974.529L890.529 250.5L972.029 372H902.029L849.029 290.5L797.529 372Z"
				fill="currentColor"
			/>
			<path
				d="M994.142 125H1150.14V176H994.142V125ZM1102.64 372H1041.64V48H1102.64V372Z"
				fill="currentColor"
			/>
			<path
				d="M1278.62 378.5C1254.29 378.5 1232.62 373 1213.62 362C1194.96 350.667 1180.29 335.333 1169.62 316C1158.96 296.333 1153.62 273.833 1153.62 248.5C1153.62 222.833 1158.79 200.167 1169.12 180.5C1179.46 160.833 1193.96 145.5 1212.62 134.5C1231.29 123.167 1252.62 117.5 1276.62 117.5C1301.62 117.5 1323.12 122.833 1341.12 133.5C1359.12 143.833 1372.96 158.333 1382.62 177C1392.62 195.667 1397.62 218 1397.62 244V262.5L1185.62 263L1186.62 224H1337.12C1337.12 207 1331.62 193.333 1320.62 183C1309.96 172.667 1295.46 167.5 1277.12 167.5C1262.79 167.5 1250.62 170.5 1240.62 176.5C1230.96 182.5 1223.62 191.5 1218.62 203.5C1213.62 215.5 1211.12 230.167 1211.12 247.5C1211.12 274.167 1216.79 294.333 1228.12 308C1239.79 321.667 1256.96 328.5 1279.62 328.5C1296.29 328.5 1309.96 325.333 1320.62 319C1331.62 312.667 1338.79 303.667 1342.12 292H1398.62C1393.29 319 1379.96 340.167 1358.62 355.5C1337.62 370.833 1310.96 378.5 1278.62 378.5Z"
				fill="currentColor"
			/>
			<path
				d="M1484.44 372H1423.44V125H1479.94L1484.94 157C1492.61 144.667 1503.44 135 1517.44 128C1531.78 121 1547.28 117.5 1563.94 117.5C1594.94 117.5 1618.28 126.667 1633.94 145C1649.94 163.333 1657.94 188.333 1657.94 220V372H1596.94V234.5C1596.94 213.833 1592.28 198.5 1582.94 188.5C1573.61 178.167 1560.94 173 1544.94 173C1525.94 173 1511.11 179 1500.44 191C1489.78 203 1484.44 219 1484.44 239V372Z"
				fill="currentColor"
			/>
			<path
				d="M1798.38 378.5C1774.38 378.5 1753.71 373.167 1736.38 362.5C1719.38 351.5 1706.04 336.333 1696.38 317C1687.04 297.667 1682.38 275.167 1682.38 249.5C1682.38 223.833 1687.04 201.167 1696.38 181.5C1706.04 161.5 1719.88 145.833 1737.88 134.5C1755.88 123.167 1777.21 117.5 1801.88 117.5C1819.21 117.5 1835.04 121 1849.38 128C1863.71 134.667 1874.71 144.167 1882.38 156.5V0H1942.88V372H1886.88L1882.88 333.5C1875.54 347.5 1864.21 358.5 1848.88 366.5C1833.88 374.5 1817.04 378.5 1798.38 378.5ZM1811.88 322.5C1826.21 322.5 1838.54 319.5 1848.88 313.5C1859.21 307.167 1867.21 298.333 1872.88 287C1878.88 275.333 1881.88 262.167 1881.88 247.5C1881.88 232.5 1878.88 219.5 1872.88 208.5C1867.21 197.167 1859.21 188.333 1848.88 182C1838.54 175.333 1826.21 172 1811.88 172C1797.88 172 1785.71 175.333 1775.38 182C1765.04 188.333 1757.04 197.167 1751.38 208.5C1746.04 219.833 1743.38 232.833 1743.38 247.5C1743.38 262.167 1746.04 275.167 1751.38 286.5C1757.04 297.833 1765.04 306.667 1775.38 313C1785.71 319.333 1797.88 322.5 1811.88 322.5Z"
				fill="currentColor"
			/>
			<path
				d="M1996.45 372V125H2057.45V372H1996.45ZM2026.45 75.5C2016.11 75.5 2007.28 72 1999.95 65C1992.95 57.6667 1989.45 48.8333 1989.45 38.5C1989.45 28.1667 1992.95 19.5 1999.95 12.5C2007.28 5.50001 2016.11 2.00002 2026.45 2.00002C2036.78 2.00002 2045.45 5.50001 2052.45 12.5C2059.78 19.5 2063.45 28.1667 2063.45 38.5C2063.45 48.8333 2059.78 57.6667 2052.45 65C2045.45 72 2036.78 75.5 2026.45 75.5Z"
				fill="currentColor"
			/>
			<path
				d="M2085.97 125H2240.97V176H2085.97V125ZM2241.47 2.5V54.5C2238.14 54.5 2234.64 54.5 2230.97 54.5C2227.64 54.5 2224.14 54.5 2220.47 54.5C2205.14 54.5 2194.8 58.1667 2189.47 65.5C2184.47 72.8333 2181.97 82.6667 2181.97 95V372H2121.47V95C2121.47 72.3333 2125.14 54.1667 2132.47 40.5C2139.8 26.5 2150.14 16.3333 2163.47 10C2176.8 3.33334 2192.3 0 2209.97 0C2214.97 0 2220.14 0.166671 2225.47 0.5C2231.14 0.833329 2236.47 1.49999 2241.47 2.5Z"
				fill="currentColor"
			/>
			<path
				d="M2330.4 125L2410.9 353L2377.9 415.5L2265.9 125H2330.4ZM2272.4 486.5V436H2308.9C2316.9 436 2323.9 435 2329.9 433C2335.9 431.333 2341.24 428 2345.9 423C2350.9 418 2355.07 410.667 2358.4 401L2460.9 125H2523.9L2402.9 427C2393.9 449.667 2382.57 466.167 2368.9 476.5C2355.24 486.833 2338.24 492 2317.9 492C2309.24 492 2301.07 491.5 2293.4 490.5C2286.07 489.833 2279.07 488.5 2272.4 486.5Z"
				fill="currentColor"
			/>
			<path
				fillRule="evenodd"
				clipRule="evenodd"
				d="M226.926 25.1299H310.197C333.783 25.1299 342.32 27.5938 350.948 32.1932C359.576 36.8108 366.326 43.5822 370.941 52.1969C375.556 60.8298 378 69.3715 378 92.9707V176.289C378 199.888 375.537 208.43 370.941 217.063C366.326 225.696 359.558 232.449 350.948 237.066C347.091 239.131 343.244 240.83 338.064 242.047V308.355C338.064 344.802 334.261 357.994 327.162 371.327C320.034 384.66 309.583 395.09 296.285 402.221C282.96 409.353 269.775 413.13 233.349 413.13H104.744C68.3172 413.13 55.1327 409.325 41.8073 402.221C28.4819 395.09 18.0583 384.632 10.9308 371.327C3.80323 358.023 0 344.802 0 308.355V179.706C0 143.259 3.80323 130.067 10.9026 116.734C18.0301 103.401 28.4819 92.9431 41.8073 85.8116C55.1045 78.7082 68.3172 74.9028 104.744 74.9028H159.808C160.841 64.0747 162.996 58.1666 166.165 52.2151C170.78 43.5822 177.547 36.8108 186.175 32.1932C194.785 27.5938 203.34 25.1299 226.926 25.1299ZM184.128 78.1641C184.128 62.7001 196.658 50.1641 212.114 50.1641H324.991C340.448 50.1641 352.978 62.7001 352.978 78.1641V191.096C352.978 206.56 340.448 219.096 324.991 219.096H212.114C196.658 219.096 184.128 206.56 184.128 191.096V78.1641Z"
				fill="currentColor"
			/>
		</svg>
	);
};

export default memo(Logo);
